#ifndef __EPD_2INCH9_H
#define __EPD_2INCH9_H

#include <avr/pgmspace.h>

 /* Pin wiring definion
 * VCC---->5V
 * GND---->GND
 * RST---->D9
 * BUSY--->D10
 * D/C---->D8
 * MOSI--->D51
 * CLK---->D52
 * CS----->D53
 * */
//IO settings
#define TEST_Pin  7 
#define BUSY_Pin  10 
#define RES_Pin   9 
#define DC_Pin    8 

#define CS_Pin    53 
#define SCK_Pin   52 
#define SDI_Pin   51

#define black   0x00  /// 00
#define white   0x01  /// 01
#define yellow  0x02  /// 10
#define red     0x03  /// 11

#define EPD_WIDTH   168
#define EPD_HEIGHT  384
#define EPD_ARRAY  EPD_WIDTH*EPD_HEIGHT/4


#define Source_BITS     168
#define Gate_BITS   384
#define ALLSCREEN_BYTES  16128 

// Color
#define  EPD_2IN9G_BLACK   0x0
#define  EPD_2IN9G_WHITE   0x1
#define  EPD_2IN9G_YELLOW  0x2
#define  EPD_2IN9G_RED     0x3


#define TEST_0  digitalWrite(TEST_Pin,LOW)
#define TEST_1  digitalWrite(TEST_Pin,HIGH) 

#define EPD_W21_MOSI_0  digitalWrite(SDI_Pin,LOW)
#define EPD_W21_MOSI_1  digitalWrite(SDI_Pin,HIGH) 

#define EPD_W21_CLK_0  digitalWrite(SCK_Pin,LOW)
#define EPD_W21_CLK_1  digitalWrite(SCK_Pin,HIGH)

#define EPD_W21_CS_0   digitalWrite(CS_Pin,LOW)
#define EPD_W21_CS_1   digitalWrite(CS_Pin,HIGH)

#define EPD_W21_DC_0   digitalWrite(DC_Pin,LOW)
#define EPD_W21_DC_1   digitalWrite(DC_Pin,HIGH)
#define EPD_W21_RST_0  digitalWrite(RES_Pin,LOW)
#define EPD_W21_RST_1  digitalWrite(RES_Pin,HIGH)
#define isEPD_W21_BUSY digitalRead(BUSY_Pin)

void printf_begin(void);

////////FUNCTION//////
void driver_delay_us(unsigned int xus);
void driver_delay_xms(unsigned long xms);
void DELAY_S(unsigned int delaytime);     
void SPI_Delay(unsigned char xrate);
void SPI_Write(unsigned char value);
void Epaper_Write_Command(unsigned char command);
void Epaper_Write_Data(unsigned char data);
//EPD
void Epaper_READBUSY(void);
void EPD_HW_Init(void);
void EPD_Update(void);
void EPD_WhiteScreen_Black(void);
void EPD_WhiteScreen_White(void);
void EPD_DeepSleep(void);
void EPD_WhiteScreen_Red(void);
void EPD_WhiteScreen_Yellow(void);
void PIC_display(const unsigned char* picData);
void GUI_display(const unsigned char* picData);
#endif
